package test;

import org.pgusb.usb4allAPIWrapper.ReadBytes;
import org.pgusb.usb4allAPIWrapper.Usb4allAPIWrapper;

import boot.BootDataPacket;


public class TestUsb4allAPIWrapper {

	public static void printByteArray(byte[] c){
		//System.out.println("en binario: ");
		for (int i=0;i<c.length;i++){
			String s = Integer.toHexString(Byte.valueOf(c[i]));
			if (s.length()>1) s = s.substring(s.length()-2);
			else s = "0"+s;
			System.out.print(s +" ");
		}
		System.out.println();
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		
		int cantBoards =-1;
		try {
			cantBoards = Usb4allAPIWrapper.getU4ABoards();
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		System.out.println("La cantidad de baseboards es: "+ cantBoards);
		if (cantBoards>0){
			int[] boards_serials = new int[cantBoards];
		
		
			for (int i=0;i<cantBoards;i++){
				int serial =-1;
				try {
					serial = Usb4allAPIWrapper.getSerialNumber(i);
				} catch (Exception e){
					System.out.println(e.getMessage());
				}
				boards_serials[i]=serial;
				System.out.println("board: "+ i+ " -- serialNumber = "+ serial);
			}
			int res=44;
			try {
				res = Usb4allAPIWrapper.apiVersion();
			} catch (Exception e){
				System.out.println(e.getMessage());
			}
			System.out.println("Version de la dll: " + res );
			
			//prueba del open
			//hago un open del 1er baseboard.			
			
			try {
				res = Usb4allAPIWrapper.openDevice(boards_serials[0], "boot", Usb4allAPIWrapper.BULK_IN,  Usb4allAPIWrapper.BULK_OUT);
			} catch (Exception e){
				System.out.println(e.getMessage());
			}
			System.out.println("Handler: " + res );
			int idModule = res;
			/*
			try {
				res = Usb4allAPIWrapper.openDevice("boot", Usb4allAPIWrapper.INT_IN,  Usb4allAPIWrapper.INT_OUT);
			} catch (Exception e){
				System.out.println(e.getMessage());
			}
			System.out.println("Handler: " + res );
			*/
			
			
			/*
			//pruebo reset
			BootDataPacket bdp = new BootDataPacket(BootDataPacket.RESET,0,4,null);
			
			try {
				res = Usb4allAPIWrapper.sendData(1,bdp.getPacket(),bdp.getPacket().length);
			} catch (Exception e){
				System.out.println(e.getMessage());
			}
			*/
			
			
			//for (int i = 0; i<100; i++){
				//pruebo receive
				/*
				BootDataPacket bdp = new BootDataPacket(BootDataPacket.READ_VERSION,0,4,null);
				try {
					res = Usb4allAPIWrapper.sendData(handler,bdp.getPacket(),bdp.getPacket().length);
				} catch (Exception e){
					System.out.println(e.getMessage());
				}
				*/
			
			/*
				BootDataPacket bdp = new BootDataPacket(BootDataPacket.READ_VERSION,0,4,null);
				byte[] data = new byte[2];
				data[0]= 0x00;
				data[1]= 0x02;
				try {
					res = Usb4allAPIWrapper.sendData(idModule,data,data.length);
				} catch (Exception e){
					System.out.println(e.getMessage());
				}
				int r=4;
				ReadBytes rb = null;
				try {
					rb = Usb4allAPIWrapper.receiveData(idModule,4);
				} catch (Exception e){
					System.out.println(e.getMessage());
				}
				System.out.print("respuesta del readBytes: ");
				printByteArray(rb.getReadBytes());
				//System.out.println();
				
			//}
			*/
			
	//		prueba del close
			try {
				res = Usb4allAPIWrapper.closeDevice(idModule);
			} catch (Exception e){
				System.out.println(e.getMessage());
			}
			System.out.println("close: " + res);
			
			
			/*
			try {
				res = Usb4allAPIWrapper.openDevice(11111111, "boot", Usb4allAPIWrapper.BULK_IN,  Usb4allAPIWrapper.BULK_OUT);
			} catch (Exception e){
				System.out.println(e.getMessage());
			}
			System.out.println("Handler: " + res );
			
			try {
				res = Usb4allAPIWrapper.closeDevice(idModule);
			} catch (Exception e){
				System.out.println(e.getMessage());
			}
			System.out.println("close: " + res);
			
			
			try {
				res = Usb4allAPIWrapper.openDevice(11111111, "boot", Usb4allAPIWrapper.BULK_IN,  Usb4allAPIWrapper.BULK_OUT);
			} catch (Exception e){
				System.out.println(e.getMessage());
			}
			System.out.println("Handler: " + res );
			
			try {
				res = Usb4allAPIWrapper.closeDevice(idModule);
			} catch (Exception e){
				System.out.println(e.getMessage());
			}
			System.out.println("close: " + res);
			*/
		}
		else {
			System.out.println("No hay baseboards conectados");
		}
	}

}
